/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.io.File;
import tim.prune.data.ExtensionInfo;
import tim.prune.data.FileType;

public class SourceInfo {
    private final File _sourceFile;
    private final String _sourceName;
    private final FileType _fileType;
    private final String _fileVersion;
    private String _fileTitle = null;
    private String _fileDescription = null;
    private ExtensionInfo _extensionInfo = null;
    private int _numPoints = 0;

    public SourceInfo(File file, FileType fileType) {
        this(file, fileType, null);
    }

    public SourceInfo(File file, FileType fileType, String string) {
        this._sourceFile = file;
        this._sourceName = file.getName();
        this._fileType = fileType;
        this._fileVersion = string;
    }

    public SourceInfo(String string, FileType fileType) {
        this._sourceFile = null;
        this._sourceName = string;
        this._fileType = fileType;
        this._fileVersion = null;
    }

    public void setFileTitle(String string) {
        this._fileTitle = string;
    }

    public void setFileDescription(String string) {
        this._fileDescription = string;
    }

    public void setExtensionInfo(ExtensionInfo extensionInfo) {
        this._extensionInfo = extensionInfo;
    }

    public File getFile() {
        return this._sourceFile;
    }

    public String getName() {
        return this._sourceName;
    }

    public FileType getFileType() {
        return this._fileType;
    }

    public String getFileVersion() {
        return this._fileVersion;
    }

    public String getFileTitle() {
        return this._fileTitle;
    }

    public String getFileDescription() {
        return this._fileDescription;
    }

    public void setNumPoints(int n) {
        this._numPoints = n;
    }

    public int getNumPoints() {
        return this._numPoints;
    }

    public String getExtensions() {
        if (this._extensionInfo == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (String string : this._extensionInfo.getExtensions()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    public ExtensionInfo getExtensionInfo() {
        return this._extensionInfo;
    }
}

