// This file is auto-generated from the corresponding file in /dev_mode
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

// We dynamically set the webpack public path based on the page config
// settings from the JupyterLab app. We copy some of the pageconfig parsing
// logic in @jupyterlab/coreutils below, since this must run before any other
// files are loaded (including @jupyterlab/coreutils).

/**
 * Get global configuration data for the Jupyter application.
 *
 * @param name - The name of the configuration option.
 *
 * @returns The config value or an empty string if not found.
 *
 * #### Notes
 * All values are treated as strings.
 * For browser based applications, it is assumed that the page HTML
 * includes a script tag with the id `jupyter-config-data` containing the
 * configuration as valid JSON.  In order to support the classic Notebook,
 * we fall back on checking for `body` data of the given `name`.
 */
function getOption(name) {
  let configData = Object.create(null);
  // Use script tag if available.
  if (typeof document !== 'undefined' && document) {
    const el = document.getElementById('jupyter-config-data');

    if (el) {
      configData = JSON.parse(el.textContent || '{}');
    }
  }
  return configData[name] || '';
}

// eslint-disable-next-line no-undef
__webpack_public_path__ = getOption('fullStaticUrl') + '/';
