/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.spies;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.spies.MultiSpyBase;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultiOnItemSpy<T>
extends MultiSpyBase<T> {
    private final List<T> items;

    public List<T> items() {
        if (this.items != null) {
            List<T> view = Collections.synchronizedList(this.items);
            return view;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        super.reset();
        if (this.items != null) {
            List<T> list = this.items;
            synchronized (list) {
                this.items.clear();
            }
        }
    }

    MultiOnItemSpy(Multi<? extends T> upstream, boolean trackItems) {
        super(upstream);
        this.items = trackItems ? new ArrayList<T>() : null;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.onItem().invoke((? super T item) -> {
            this.incrementInvocationCount();
            if (this.items != null) {
                List<T> list = this.items;
                synchronized (list) {
                    this.items.add(item);
                }
            }
        }).subscribe().withSubscriber(downstream);
    }

    @Override
    public String toString() {
        return "MultiOnItemSpy{items=" + String.valueOf(this.items) + "} " + super.toString();
    }
}

