/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DeliverSmResp;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.OutboundResponseHandler;
import org.jsmpp.session.state.SMPPOutboundSessionBound;
import org.jsmpp.session.state.SMPPOutboundSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPOutboundSessionBoundRX
extends SMPPOutboundSessionBound
implements SMPPOutboundSessionState {
    private static final Logger logger = LoggerFactory.getLogger(SMPPOutboundSessionBoundRX.class);
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();

    SMPPOutboundSessionBoundRX() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.BOUND_RX;
    }

    @Override
    public void processDeliverSmResp(Command pduHeader, byte[] pdu, OutboundResponseHandler responseHandler) throws IOException {
        SMPPOutboundSessionBoundRX.processDeliverSmResp0(pduHeader, pdu, responseHandler);
    }

    static final void processDeliverSmResp0(Command pduHeader, byte[] pdu, OutboundResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            DeliverSmResp resp = pduDecomposer.deliverSmResp(pdu);
            pendingResp.done(resp);
        } else {
            logger.warn("No request with sequence_number {} found", (Object)pduHeader.getSequenceNumber());
        }
    }
}

