/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.jobscheduler.scheduler.JobSchedulingInfo;

public class ScheduledJobInfo {
    private Map<String, Map<String, JobSchedulingInfo>> jobInfoMap = new ConcurrentHashMap<String, Map<String, JobSchedulingInfo>>();

    ScheduledJobInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JobSchedulingInfo> getJobsByIndex(String indexName) {
        if (!this.jobInfoMap.containsKey(indexName)) {
            Map<String, Map<String, JobSchedulingInfo>> map = this.jobInfoMap;
            synchronized (map) {
                if (!this.jobInfoMap.containsKey(indexName)) {
                    this.jobInfoMap.put(indexName, new ConcurrentHashMap());
                }
            }
        }
        return this.jobInfoMap.get(indexName);
    }

    public JobSchedulingInfo getJobInfo(String indexName, String jobId) {
        return this.getJobsByIndex(indexName).get(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(String indexName, String jobId, JobSchedulingInfo jobInfo) {
        if (!this.jobInfoMap.containsKey(indexName)) {
            Map<String, Map<String, JobSchedulingInfo>> map = this.jobInfoMap;
            synchronized (map) {
                if (!this.jobInfoMap.containsKey(indexName)) {
                    this.jobInfoMap.put(indexName, new ConcurrentHashMap());
                }
            }
        }
        this.jobInfoMap.get(indexName).put(jobId, jobInfo);
    }

    public Map<String, Map<String, JobSchedulingInfo>> getJobInfoMap() {
        return Map.copyOf(this.jobInfoMap);
    }

    public JobSchedulingInfo removeJob(String indexName, String jobId) {
        if (this.jobInfoMap.containsKey(indexName)) {
            return this.jobInfoMap.get(indexName).remove(jobId);
        }
        return null;
    }
}

