/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.impl;

import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceException;
import com.oracle.labs.mlrg.olcut.provenance.impl.SkeletalConfiguredObjectProvenance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ConfiguredObjectProvenanceImpl
extends SkeletalConfiguredObjectProvenance {
    private static final long serialVersionUID = 1L;

    public <T extends Configurable> ConfiguredObjectProvenanceImpl(T host, String hostTypeStringName) {
        super(host, hostTypeStringName);
    }

    public ConfiguredObjectProvenanceImpl(Map<String, Provenance> map) {
        super(ConfiguredObjectProvenanceImpl.extractProvenanceInfo(map));
    }

    protected static SkeletalConfiguredObjectProvenance.ExtractedInfo extractProvenanceInfo(Map<String, Provenance> map) {
        HashMap<String, Provenance> configuredParameters = new HashMap<String, Provenance>(map);
        if (!configuredParameters.containsKey("class-name")) {
            throw new ProvenanceException("Failed to find class name when constructing ConfiguredObjectProvenanceImpl");
        }
        String className = ((Provenance)configuredParameters.remove("class-name")).toString();
        if (!configuredParameters.containsKey("host-short-name")) {
            throw new ProvenanceException("Failed to find host type short name when constructing ConfiguredObjectProvenanceImpl");
        }
        String hostTypeStringName = ((Provenance)configuredParameters.remove("host-short-name")).toString();
        return new SkeletalConfiguredObjectProvenance.ExtractedInfo(className, hostTypeStringName, configuredParameters, Collections.emptyMap());
    }
}

