/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.inclusionrule;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public class ListExclusionRule
implements InclusionRule {
    private static final long serialVersionUID = -6315037625922693976L;
    private static final Logger LOGGER = Logger.getLogger(ListExclusionRule.class.getName());
    private final List<String> exclusions;

    public ListExclusionRule(List<String> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            throw new IllegalArgumentException("No exclusions provided");
        }
        this.exclusions = exclusions;
    }

    @Override
    public boolean test(String text) {
        if (Utility.isBlank(text)) {
            return false;
        }
        if (this.exclusions.contains(text)) {
            LOGGER.log(Level.FINE, new StringFormat("Excluding <%s> since it is on the exclude list", text));
            return false;
        }
        LOGGER.log(Level.FINE, new StringFormat("Including <%s>", text));
        return true;
    }
}

