/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.core.util.VersionUtil;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeIdResolver;

public abstract class TypeSerializer {
    public abstract TypeSerializer forProperty(SerializationContext var1, BeanProperty var2);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public WritableTypeId typeId(Object value, JsonToken valueShape) {
        WritableTypeId typeIdDef = new WritableTypeId(value, valueShape);
        switch (this.getTypeInclusion()) {
            case EXISTING_PROPERTY: {
                typeIdDef.include = WritableTypeId.Inclusion.PAYLOAD_PROPERTY;
                typeIdDef.asProperty = this.getPropertyName();
                break;
            }
            case EXTERNAL_PROPERTY: {
                typeIdDef.include = WritableTypeId.Inclusion.PARENT_PROPERTY;
                typeIdDef.asProperty = this.getPropertyName();
                break;
            }
            case PROPERTY: {
                typeIdDef.include = WritableTypeId.Inclusion.METADATA_PROPERTY;
                typeIdDef.asProperty = this.getPropertyName();
                break;
            }
            case WRAPPER_ARRAY: {
                typeIdDef.include = WritableTypeId.Inclusion.WRAPPER_ARRAY;
                break;
            }
            case WRAPPER_OBJECT: {
                typeIdDef.include = WritableTypeId.Inclusion.WRAPPER_OBJECT;
                break;
            }
            default: {
                VersionUtil.throwInternal();
            }
        }
        return typeIdDef;
    }

    public WritableTypeId typeId(Object value, JsonToken valueShape, Object id) {
        WritableTypeId typeId = this.typeId(value, valueShape);
        typeId.id = id;
        return typeId;
    }

    public WritableTypeId typeId(Object value, Class<?> typeForId, JsonToken valueShape) {
        WritableTypeId typeId = this.typeId(value, valueShape);
        typeId.forValueType = typeForId;
        return typeId;
    }

    public abstract WritableTypeId writeTypePrefix(JsonGenerator var1, SerializationContext var2, WritableTypeId var3) throws JacksonException;

    public abstract WritableTypeId writeTypeSuffix(JsonGenerator var1, SerializationContext var2, WritableTypeId var3) throws JacksonException;
}

