/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.filesystem.MFileOS7;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.CollectionSingleIndexFile;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.util.CloseableIterator;

public class PartitionManagerFromIndexDirectory
extends CollectionAbstract
implements PartitionManager {
    private List<File> partIndexFiles;
    private final FeatureCollectionConfig config;

    public PartitionManagerFromIndexDirectory(String name, FeatureCollectionConfig config, File directory, Logger logger) {
        super(name, logger);
        this.config = config;
        this.root = directory.getPath();
        this.partIndexFiles = new ArrayList<File>();
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ncx2");
            }
        });
        if (files != null) {
            Collections.addAll(this.partIndexFiles, files);
        }
        this.putAuxInfo("fcConfig", config);
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        return new PartIterator();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Iterable<MFile> getFilesSorted() throws IOException {
        return null;
    }

    @Override
    public CloseableIterator<MFile> getFileIterator() throws IOException {
        return null;
    }

    private class PartIterator
    implements Iterator<MCollection>,
    Iterable<MCollection> {
        Iterator<File> iter;

        private PartIterator() {
            this.iter = PartitionManagerFromIndexDirectory.this.partIndexFiles.iterator();
        }

        @Override
        public Iterator<MCollection> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public MCollection next() {
            File nextFile = this.iter.next();
            try {
                CollectionSingleIndexFile result = new CollectionSingleIndexFile(new MFileOS7(nextFile.getPath()), PartitionManagerFromIndexDirectory.this.logger);
                result.putAuxInfo("fcConfig", PartitionManagerFromIndexDirectory.this.config);
                return result;
            }
            catch (IOException e) {
                PartitionManagerFromIndexDirectory.this.logger.error("PartitionManagerFromList failed on " + nextFile.getPath(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
        }
    }
}

