/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.payloads.FloatEncoder;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.apache.lucene.queries.payloads.SpanPayloadCheckQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.util.PayloadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadCheckQParserPlugin
extends QParserPlugin {
    public static final String NAME = "payload_check";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws SyntaxError {
                String[] rawPayloads;
                String field = this.localParams.get("f");
                String value = this.localParams.get("v");
                String p = this.localParams.get("payloads");
                String strOp = this.localParams.get("op");
                SpanPayloadCheckQuery.MatchOperation op = SpanPayloadCheckQuery.MatchOperation.EQ;
                if (strOp != null) {
                    op = SpanPayloadCheckQuery.MatchOperation.valueOf((String)strOp.toUpperCase(Locale.ROOT));
                }
                if (field == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'f' not specified");
                }
                if (value == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "query string missing");
                }
                if (p == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'payloads' not specified");
                }
                FieldType ft = this.req.getCore().getLatestSchema().getFieldType(field);
                Analyzer analyzer = ft.getQueryAnalyzer();
                SpanQuery query = null;
                try {
                    query = PayloadUtils.createSpanQuery(field, value, analyzer);
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
                }
                if (query == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "SpanQuery is null");
                }
                FloatEncoder encoder = null;
                String e = PayloadUtils.getPayloadEncoder(ft);
                SpanPayloadCheckQuery.PayloadType payloadType = null;
                if ("float".equals(e)) {
                    encoder = new FloatEncoder();
                    payloadType = SpanPayloadCheckQuery.PayloadType.FLOAT;
                } else if ("integer".equals(e)) {
                    encoder = new IntegerEncoder();
                    payloadType = SpanPayloadCheckQuery.PayloadType.INT;
                } else if ("identity".equals(e)) {
                    encoder = new IdentityEncoder();
                    payloadType = SpanPayloadCheckQuery.PayloadType.STRING;
                }
                if (encoder == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid encoder: " + e + " for field: " + field);
                }
                ArrayList<BytesRef> payloads = new ArrayList<BytesRef>();
                for (String rawPayload : rawPayloads = p.split(" ")) {
                    if (rawPayload.length() <= 0) continue;
                    payloads.add(encoder.encode(rawPayload.toCharArray()));
                }
                return new SpanPayloadCheckQuery(query, payloads, payloadType, op);
            }
        };
    }
}

