/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.utils.Logging;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.network.SocketServerConfigs;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CoreUtils$ {
    public static final CoreUtils$ MODULE$ = new CoreUtils$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass());
    private static final InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();

    private Logger logger() {
        return logger;
    }

    private InetAddressValidator inetAddressValidator() {
        return inetAddressValidator;
    }

    public void swallow(Function0<BoxedUnit> action, Logging logging, Level logLevel) {
        try {
            action.apply$mcV$sp();
            return;
        }
        catch (Throwable e) {
            if (Level.ERROR.equals(logLevel)) {
                logging.error((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.WARN.equals(logLevel)) {
                logging.warn((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.INFO.equals(logLevel)) {
                logging.info((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.DEBUG.equals(logLevel)) {
                logging.debug((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            if (Level.TRACE.equals(logLevel)) {
                logging.trace((Function0<String>)(Function0 & Serializable)() -> e.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
            throw new MatchError((Object)logLevel);
        }
    }

    public Level swallow$default$3() {
        return Level.WARN;
    }

    public void delete(List<String> files) {
        files.forEach(f -> Utils.delete((File)new File((String)f)));
    }

    public boolean registerMBean(Object mbean, String name) {
        boolean bl;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            synchronized (mbs) {
                ObjectName objName = new ObjectName(name);
                if (mbs.isRegistered(objName)) {
                    mbs.unregisterMBean(objName);
                }
                mbs.registerMBean(mbean, objName);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : mbs
                bl = bl2;
            }
        }
        catch (Exception e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Failed to register Mbean " + name, (Throwable)e);
            }
            bl = false;
        }
        return bl;
    }

    public <T> T inLock(Lock lock, Function0<T> fun) {
        Object object;
        lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    public <T> T inReadLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.readLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public <T> T inWriteLock(ReadWriteLock lock, Function0<T> fun) {
        Object object;
        Lock inLock_lock = lock.writeLock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public Seq<Endpoint> listenerListToEndPoints(String listeners, java.util.Map<ListenerName, SecurityProtocol> securityProtocolMap) {
        return this.listenerListToEndPoints(listeners, securityProtocolMap, true);
    }

    private void checkDuplicateListenerPorts(Seq<Endpoint> endpoints, String listeners) {
        Seq distinctPorts = (Seq)((SeqOps)endpoints.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.port()))).distinct();
        Predef$.MODULE$.require(distinctPorts.size() == ((SeqOps)endpoints.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.port()))).size(), (Function0 & Serializable)() -> "Each listener must have a different port, listeners: " + listeners);
    }

    public Seq<Endpoint> listenerListToEndPoints(String listeners, java.util.Map<ListenerName, SecurityProtocol> securityProtocolMap, boolean requireDistinctPorts) {
        Buffer buffer;
        try {
            buffer = CollectionConverters$.MODULE$.ListHasAsScala(SocketServerConfigs.listenerListToEndPoints((String)listeners, securityProtocolMap)).asScala();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating broker listeners from '" + listeners + "': " + e.getMessage(), e);
        }
        Buffer endPoints = buffer;
        this.validate$1((Seq)endPoints, listeners, requireDistinctPorts);
        return endPoints;
    }

    private final boolean validateOneIsIpv4AndOtherIpv6$1(String first, String second) {
        return this.inetAddressValidator().isValidInet4Address(first) && this.inetAddressValidator().isValidInet6Address(second) || this.inetAddressValidator().isValidInet6Address(first) && this.inetAddressValidator().isValidInet4Address(second);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$3(Endpoint ep) {
        return ep.port() != 0;
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$5(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((Seq)x0$1._2()).size() > 1;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$listenerListToEndPoints$7(Endpoint ep) {
        return ep.host() != null && MODULE$.inetAddressValidator().isValid(ep.host());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$listenerListToEndPoints$8(CoreUtils$ $this, boolean requireDistinctPorts$1, String listeners$2, Tuple2 x0$3) {
        if (x0$3 == null) throw new MatchError((Object)x0$3);
        int port = x0$3._1$mcI$sp();
        Tuple2 tuple2 = (Tuple2)x0$3._2();
        if (tuple2 == null) throw new MatchError((Object)x0$3);
        Seq duplicatesWithIpHosts = (Seq)tuple2._1();
        Seq duplicatesWithoutIpHosts = (Seq)tuple2._2();
        if (requireDistinctPorts$1) {
            MODULE$.checkDuplicateListenerPorts((Seq<Endpoint>)duplicatesWithoutIpHosts, listeners$2);
        }
        if (duplicatesWithIpHosts.isEmpty()) {
            return;
        }
        SeqOps seqOps = Seq$.MODULE$.unapplySeq((SeqOps)duplicatesWithIpHosts);
        if (!SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps)) {
            new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
            if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Endpoint ep1 = (Endpoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Endpoint ep2 = (Endpoint)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (!requireDistinctPorts$1) return;
                String errorMessage = "If you have two listeners on the same port then one needs to be IPv4 and the other IPv6, listeners: " + listeners$2 + ", port: " + port;
                Predef$.MODULE$.require($this.validateOneIsIpv4AndOtherIpv6$1(ep1.host(), ep2.host()), (Function0 & Serializable)() -> errorMessage);
                if (!duplicatesWithoutIpHosts.nonEmpty()) return;
                throw new IllegalArgumentException(errorMessage);
            }
        }
        if (!requireDistinctPorts$1) return;
        throw new IllegalArgumentException("Each listener must have a different port unless exactly one listener has an IPv4 address and the other IPv6 address, listeners: " + listeners$2 + ", port: " + port);
    }

    /*
     * WARNING - void declaration
     */
    private final void validate$1(Seq endPoints, String listeners$2, boolean requireDistinctPorts$1) {
        void var6_6;
        Seq distinctListenerNames = (Seq)((SeqOps)endPoints.map((Function1 & Serializable)x$3 -> x$3.listener())).distinct();
        Predef$.MODULE$.require(distinctListenerNames.size() == endPoints.size(), (Function0 & Serializable)() -> "Each listener must have a different name, listeners: " + listeners$2);
        Tuple2 tuple2 = ((IterableOps)endPoints.filter((Function1 & Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$3(ep)))).groupBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.port())).partition((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$5(x0$1)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map duplicatePorts = (Map)tuple2._1();
        ((Map)var6_6.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int port = x0$2._1$mcI$sp();
                Seq eps = (Seq)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)port), (Object)eps.partition((Function1 & Serializable)ep -> BoxesRunTime.boxToBoolean((boolean)CoreUtils$.$anonfun$listenerListToEndPoints$7(ep))));
            }
            throw new MatchError(null);
        })).foreach((Function1 & Serializable)x0$3 -> {
            CoreUtils$.$anonfun$listenerListToEndPoints$8(this, requireDistinctPorts$1, listeners$2, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    private CoreUtils$() {
    }
}

