/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.UpdateRaftVoterRequestData;
import org.apache.kafka.common.message.UpdateRaftVoterResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.KRaftVersionUpgrade;
import org.apache.kafka.raft.internals.LogHistory;
import org.apache.kafka.server.common.KRaftVersion;
import org.slf4j.Logger;

public final class UpdateVoterHandler {
    private final OptionalInt localId;
    private final KRaftControlRecordStateMachine partitionState;
    private final ListenerName defaultListenerName;
    private final Logger log;

    public UpdateVoterHandler(OptionalInt localId, KRaftControlRecordStateMachine partitionState, ListenerName defaultListenerName, LogContext logContext) {
        this.localId = localId;
        this.partitionState = partitionState;
        this.defaultListenerName = defaultListenerName;
        this.log = logContext.logger(this.getClass());
    }

    public CompletableFuture<UpdateRaftVoterResponseData> handleUpdateVoterRequest(LeaderState<?> leaderState, ListenerName requestListenerName, ReplicaKey voterKey, Endpoints voterEndpoints, UpdateRaftVoterRequestData.KRaftVersionFeature supportedKraftVersions, long currentTimeMs) {
        Optional<VoterSet> voters;
        Optional<Object> inMemoryVoters;
        if (leaderState.isOperationPending(currentTimeMs)) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        Optional<Long> highWatermark = leaderState.highWatermark().map(LogOffsetMetadata::offset);
        if (highWatermark.isEmpty()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        KRaftVersion kraftVersion = this.partitionState.lastKraftVersion();
        if (kraftVersion.isReconfigSupported()) {
            inMemoryVoters = Optional.empty();
            Optional<LogHistory.Entry<VoterSet>> votersEntry = this.partitionState.lastVoterSetEntry();
            voters = votersEntry.isEmpty() || votersEntry.get().offset() >= highWatermark.get() ? Optional.empty() : votersEntry.map(LogHistory.Entry::value);
        } else {
            inMemoryVoters = leaderState.volatileVoters();
            if (inMemoryVoters.isEmpty()) {
                return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
            }
            voters = inMemoryVoters.map(KRaftVersionUpgrade.Voters::voters);
        }
        if (voters.isEmpty()) {
            this.log.info("Unable to read the current voter set with kraft version {}", (Object)kraftVersion);
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        if (!this.validVersionRange(kraftVersion, supportedKraftVersions)) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.INVALID_REQUEST, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        if (voterEndpoints.address(this.defaultListenerName).isEmpty()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.INVALID_REQUEST, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        Optional<VoterSet> updatedVoters = this.updateVoters(voters.get(), kraftVersion, VoterSet.VoterNode.of(voterKey, voterEndpoints, new SupportedVersionRange(supportedKraftVersions.minSupportedVersion(), supportedKraftVersions.maxSupportedVersion())));
        if (updatedVoters.isEmpty()) {
            return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.VOTER_NOT_FOUND, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
        }
        return this.storeUpdatedVoters(leaderState, voterKey, inMemoryVoters, updatedVoters.get(), requestListenerName, currentTimeMs);
    }

    private boolean validVersionRange(KRaftVersion finalizedVersion, UpdateRaftVoterRequestData.KRaftVersionFeature supportedKraftVersions) {
        return supportedKraftVersions.minSupportedVersion() <= finalizedVersion.featureLevel() && supportedKraftVersions.maxSupportedVersion() >= finalizedVersion.featureLevel();
    }

    private Optional<VoterSet> updateVoters(VoterSet voters, KRaftVersion kraftVersion, VoterSet.VoterNode updatedVoter) {
        return kraftVersion.isReconfigSupported() ? voters.updateVoter(updatedVoter) : voters.updateVoterIgnoringDirectoryId(updatedVoter);
    }

    private CompletableFuture<UpdateRaftVoterResponseData> storeUpdatedVoters(LeaderState<?> leaderState, ReplicaKey voterKey, Optional<KRaftVersionUpgrade.Voters> inMemoryVoters, VoterSet newVoters, ListenerName requestListenerName, long currentTimeMs) {
        if (inMemoryVoters.isEmpty()) {
            leaderState.appendVotersRecord(newVoters, currentTimeMs);
        } else {
            boolean successful = leaderState.compareAndSetVolatileVoters(inMemoryVoters.get(), new KRaftVersionUpgrade.Voters(newVoters));
            if (successful) {
                this.log.info("Updated in-memory voters from {} to {}", (Object)inMemoryVoters.get().voters(), (Object)newVoters);
            } else {
                this.log.info("Unable to update in-memory voters from {} to {}", (Object)inMemoryVoters.get().voters(), (Object)newVoters);
                return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.REQUEST_TIMED_OUT, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
            }
        }
        leaderState.updateCheckQuorumForFollowingVoter(voterKey, currentTimeMs);
        return CompletableFuture.completedFuture(RaftUtil.updateVoterResponse(Errors.NONE, requestListenerName, new LeaderAndEpoch(this.localId, leaderState.epoch()), leaderState.leaderEndpoints()));
    }
}

