/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;

public class InstantiableClassValidator
implements ConfigDef.Validator {
    public void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        Class cls = (Class)value;
        try {
            Object o = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Utils.maybeCloseQuietly(o, (String)(String.valueOf(o) + " (instantiated for preflight validation"));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ConfigException(name, (Object)cls.getName(), "Could not find a public no-argument constructor for class" + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
        }
        catch (LinkageError | ReflectiveOperationException | RuntimeException e) {
            throw new ConfigException(name, (Object)cls.getName(), "Could not instantiate class" + (String)(e.getMessage() != null ? ": " + e.getMessage() : ""));
        }
    }

    public String toString() {
        return "A class with a public, no-argument constructor";
    }
}

