/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogMetadataTopicPartitioner {
    public static final Logger log = LoggerFactory.getLogger(RemoteLogMetadataTopicPartitioner.class);
    private final int numMetadataTopicPartitions;

    public RemoteLogMetadataTopicPartitioner(int numMetadataTopicPartitions) {
        this.numMetadataTopicPartitions = numMetadataTopicPartitions;
    }

    public int metadataPartition(TopicIdPartition topicIdPartition) {
        Objects.requireNonNull(topicIdPartition, "TopicPartition can not be null");
        int partitionNum = Utils.toPositive((int)Utils.murmur2((byte[])this.toBytes(topicIdPartition))) % this.numMetadataTopicPartitions;
        log.debug("No of partitions [{}], partitionNum: [{}] for given topic: [{}]", new Object[]{this.numMetadataTopicPartitions, partitionNum, topicIdPartition});
        return partitionNum;
    }

    private byte[] toBytes(TopicIdPartition topicIdPartition) {
        int hash = Objects.hash(topicIdPartition.topicId().getLeastSignificantBits(), topicIdPartition.topicId().getMostSignificantBits(), topicIdPartition.partition());
        return this.toBytes(hash);
    }

    private byte[] toBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }
}

