/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.sql.parser;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.AllFields;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.DescribeRelation;
import org.opensearch.sql.ast.tree.Filter;
import org.opensearch.sql.ast.tree.Limit;
import org.opensearch.sql.ast.tree.Project;
import org.opensearch.sql.ast.tree.Relation;
import org.opensearch.sql.ast.tree.RelationSubquery;
import org.opensearch.sql.ast.tree.SubqueryAlias;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.ast.tree.Values;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParser;
import org.opensearch.sql.sql.antlr.parser.OpenSearchSQLParserBaseVisitor;
import org.opensearch.sql.sql.parser.AstAggregationBuilder;
import org.opensearch.sql.sql.parser.AstExpressionBuilder;
import org.opensearch.sql.sql.parser.AstHavingFilterBuilder;
import org.opensearch.sql.sql.parser.AstSortBuilder;
import org.opensearch.sql.sql.parser.ParserUtils;
import org.opensearch.sql.sql.parser.context.ParsingContext;
import org.opensearch.sql.utils.SystemIndexUtils;
import shaded.com.google.common.collect.ImmutableList;

public class AstBuilder
extends OpenSearchSQLParserBaseVisitor<UnresolvedPlan> {
    private final AstExpressionBuilder expressionBuilder = new AstExpressionBuilder();
    private final ParsingContext context = new ParsingContext();
    private final String query;

    @Override
    public UnresolvedPlan visitShowStatement(OpenSearchSQLParser.ShowStatementContext ctx) {
        UnresolvedExpression tableFilter = this.visitAstExpression((ParseTree)ctx.tableFilter());
        return new Project(Collections.singletonList(AllFields.of())).attach(new Filter(tableFilter).attach(new DescribeRelation(AstDSL.qualifiedName("ALL.META_ODFE_SYS_TABLE"))));
    }

    @Override
    public UnresolvedPlan visitDescribeStatement(OpenSearchSQLParser.DescribeStatementContext ctx) {
        Function tableFilter = (Function)this.visitAstExpression((ParseTree)ctx.tableFilter());
        String tableName = tableFilter.getFuncArgs().get(1).toString();
        DescribeRelation table = new DescribeRelation(AstDSL.qualifiedName(SystemIndexUtils.mappingTable(tableName.toString())));
        if (ctx.columnFilter() == null) {
            return new Project(Collections.singletonList(AllFields.of())).attach(table);
        }
        return new Project(Collections.singletonList(AllFields.of())).attach(new Filter(this.visitAstExpression((ParseTree)ctx.columnFilter())).attach(table));
    }

    @Override
    public UnresolvedPlan visitQuerySpecification(OpenSearchSQLParser.QuerySpecificationContext queryContext) {
        this.context.push();
        this.context.peek().collect(queryContext, this.query);
        Project project = (Project)this.visit((ParseTree)queryContext.selectClause());
        if (queryContext.fromClause() == null) {
            Optional<UnresolvedExpression> allFields = project.getProjectList().stream().filter(node -> node instanceof AllFields).findFirst();
            if (allFields.isPresent()) {
                throw new SyntaxCheckException("No FROM clause found for select all");
            }
            Values emptyValue = new Values((List<List<Literal>>)ImmutableList.of(Collections.emptyList()));
            return project.attach(emptyValue);
        }
        UnresolvedPlan from = (UnresolvedPlan)this.visit((ParseTree)queryContext.fromClause());
        if (queryContext.limitClause() != null) {
            from = ((UnresolvedPlan)this.visit((ParseTree)queryContext.limitClause())).attach(from);
        }
        Project result = project.attach(from);
        this.context.pop();
        return result;
    }

    @Override
    public UnresolvedPlan visitSelectClause(OpenSearchSQLParser.SelectClauseContext ctx) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (ctx.selectElements().star != null) {
            builder.add((Object)AllFields.of());
        }
        ctx.selectElements().selectElement().forEach(field -> builder.add((Object)this.visitSelectItem((OpenSearchSQLParser.SelectElementContext)((Object)field))));
        return new Project((List<UnresolvedExpression>)builder.build());
    }

    @Override
    public UnresolvedPlan visitLimitClause(OpenSearchSQLParser.LimitClauseContext ctx) {
        return new Limit(Integer.parseInt(ctx.limit.getText()), ctx.offset == null ? 0 : Integer.parseInt(ctx.offset.getText()));
    }

    @Override
    public UnresolvedPlan visitFromClause(OpenSearchSQLParser.FromClauseContext ctx) {
        AstAggregationBuilder aggBuilder;
        UnresolvedPlan aggregation;
        UnresolvedPlan result = (UnresolvedPlan)this.visit((ParseTree)ctx.relation());
        if (ctx.whereClause() != null) {
            result = ((UnresolvedPlan)this.visit((ParseTree)ctx.whereClause())).attach(result);
        }
        if ((aggregation = (aggBuilder = new AstAggregationBuilder(this.context.peek())).visit((ParseTree)ctx.groupByClause())) != null) {
            result = aggregation.attach(result);
        }
        if (ctx.havingClause() != null) {
            UnresolvedPlan havingPlan = (UnresolvedPlan)this.visit((ParseTree)ctx.havingClause());
            this.verifySupportsCondition(((Filter)havingPlan).getCondition());
            result = ((UnresolvedPlan)this.visit((ParseTree)ctx.havingClause())).attach(result);
        }
        if (ctx.orderByClause() != null) {
            AstSortBuilder sortBuilder = new AstSortBuilder(this.context.peek());
            result = ((UnresolvedPlan)sortBuilder.visit((ParseTree)ctx.orderByClause())).attach(result);
        }
        return result;
    }

    private void verifySupportsCondition(UnresolvedExpression func) {
        if (func instanceof Function) {
            if (((Function)func).getFuncName().equalsIgnoreCase(BuiltinFunctionName.NESTED.name())) {
                throw new SyntaxCheckException("Falling back to legacy engine. Nested function is not supported in the HAVING clause.");
            }
            ((Function)func).getFuncArgs().stream().forEach(e -> this.verifySupportsCondition((UnresolvedExpression)e));
        }
    }

    @Override
    public UnresolvedPlan visitTableAsRelation(OpenSearchSQLParser.TableAsRelationContext ctx) {
        Relation relation = new Relation(this.visitAstExpression((ParseTree)ctx.tableName()));
        return ctx.alias() != null ? new SubqueryAlias(StringUtils.unquoteIdentifier(ctx.alias().getText()), relation) : relation;
    }

    @Override
    public UnresolvedPlan visitSubqueryAsRelation(OpenSearchSQLParser.SubqueryAsRelationContext ctx) {
        String subqueryAlias = StringUtils.unquoteIdentifier(ctx.alias().getText());
        return new RelationSubquery((UnresolvedPlan)this.visit((ParseTree)ctx.subquery), subqueryAlias);
    }

    @Override
    public UnresolvedPlan visitWhereClause(OpenSearchSQLParser.WhereClauseContext ctx) {
        return new Filter(this.visitAstExpression((ParseTree)ctx.expression()));
    }

    @Override
    public UnresolvedPlan visitHavingClause(OpenSearchSQLParser.HavingClauseContext ctx) {
        AstHavingFilterBuilder builder = new AstHavingFilterBuilder(this.context.peek());
        return new Filter((UnresolvedExpression)builder.visit((ParseTree)ctx.expression()));
    }

    protected UnresolvedPlan aggregateResult(UnresolvedPlan aggregate, UnresolvedPlan nextResult) {
        return nextResult != null ? nextResult : aggregate;
    }

    private UnresolvedExpression visitAstExpression(ParseTree tree) {
        return (UnresolvedExpression)this.expressionBuilder.visit(tree);
    }

    private UnresolvedExpression visitSelectItem(OpenSearchSQLParser.SelectElementContext ctx) {
        String name = StringUtils.unquoteIdentifier(ParserUtils.getTextInQuery(ctx.expression(), this.query));
        UnresolvedExpression expr = this.visitAstExpression((ParseTree)ctx.expression());
        if (ctx.alias() == null) {
            return Alias.newAliasAllowMetaMetaField(name, expr, null);
        }
        String alias = StringUtils.unquoteIdentifier(ctx.alias().getText());
        return Alias.newAliasAllowMetaMetaField(name, expr, alias);
    }

    @Generated
    public AstBuilder(String query) {
        this.query = query;
    }
}

