/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import lombok.Generated;
import org.opensearch.sql.datasource.model.DataSourceType;

public final class SerializeUtils {
    public static GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapter(DataSourceType.class, (Object)new DataSourceTypeSerializer()).registerTypeAdapter(DataSourceType.class, (Object)new DataSourceTypeDeserializer());
    }

    public static Gson buildGson() {
        return SerializeUtils.getGsonBuilder().create();
    }

    @Generated
    private SerializeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class DataSourceTypeSerializer
    implements JsonSerializer<DataSourceType> {
        private DataSourceTypeSerializer() {
        }

        public JsonElement serialize(DataSourceType dataSourceType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(dataSourceType.name());
        }
    }

    private static class DataSourceTypeDeserializer
    implements JsonDeserializer<DataSourceType> {
        private DataSourceTypeDeserializer() {
        }

        public DataSourceType deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return DataSourceType.fromString(jsonElement.getAsString());
        }
    }
}

