/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.hll;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.SketchesStateException;
import com.yahoo.sketches.hll.AbstractCoupons;
import com.yahoo.sketches.hll.CouponList;
import com.yahoo.sketches.hll.CurMode;
import com.yahoo.sketches.hll.DirectCouponHashSet;
import com.yahoo.sketches.hll.DirectHll4Array;
import com.yahoo.sketches.hll.DirectHll6Array;
import com.yahoo.sketches.hll.DirectHll8Array;
import com.yahoo.sketches.hll.DirectHllArray;
import com.yahoo.sketches.hll.HllSketch;
import com.yahoo.sketches.hll.HllSketchImpl;
import com.yahoo.sketches.hll.HllUtil;
import com.yahoo.sketches.hll.IntMemoryPairIterator;
import com.yahoo.sketches.hll.PairIterator;
import com.yahoo.sketches.hll.PreambleUtil;
import com.yahoo.sketches.hll.TgtHllType;

class DirectCouponList
extends AbstractCoupons {
    WritableMemory wmem;
    Memory mem;
    Object memObj;
    long memAdd;
    final boolean compact;

    DirectCouponList(int lgConfigK, TgtHllType tgtHllType, CurMode curMode, WritableMemory wmem) {
        super(lgConfigK, tgtHllType, curMode);
        this.wmem = wmem;
        this.mem = wmem;
        this.memObj = wmem.getArray();
        this.memAdd = wmem.getCumulativeOffset(0L);
        this.compact = PreambleUtil.extractCompactFlag((Memory)wmem);
        assert (!this.compact);
    }

    DirectCouponList(int lgConfigK, TgtHllType tgtHllType, CurMode curMode, Memory mem) {
        super(lgConfigK, tgtHllType, curMode);
        this.wmem = null;
        this.mem = mem;
        this.memObj = ((WritableMemory)mem).getArray();
        this.memAdd = mem.getCumulativeOffset(0L);
        this.compact = PreambleUtil.extractCompactFlag(mem);
    }

    static DirectCouponList newInstance(int lgConfigK, TgtHllType tgtHllType, WritableMemory dstMem) {
        PreambleUtil.insertPreInts(dstMem, 2);
        PreambleUtil.insertSerVer(dstMem);
        PreambleUtil.insertFamilyId(dstMem);
        PreambleUtil.insertLgK(dstMem, lgConfigK);
        PreambleUtil.insertLgArr(dstMem, 3);
        PreambleUtil.insertFlags(dstMem, 4);
        PreambleUtil.insertListCount(dstMem, 0);
        PreambleUtil.insertModes(dstMem, tgtHllType, CurMode.LIST);
        return new DirectCouponList(lgConfigK, tgtHllType, CurMode.LIST, dstMem);
    }

    @Override
    CouponList copy() {
        return CouponList.heapifyList(this.mem);
    }

    @Override
    CouponList copyAs(TgtHllType tgtHllType) {
        CouponList clist = CouponList.heapifyList(this.mem);
        return new CouponList(clist, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wmem == null) {
            HllUtil.noWriteAccess();
        }
        int len = 1 << this.getLgCouponArrInts();
        for (int i = 0; i < len; ++i) {
            int couponAtIdx = PreambleUtil.extractInt(this.mem, PreambleUtil.LIST_INT_ARR_START + (i << 2));
            if (couponAtIdx == 0) {
                PreambleUtil.insertInt(this.wmem, PreambleUtil.LIST_INT_ARR_START + (i << 2), coupon);
                int couponCount = PreambleUtil.extractListCount(this.mem);
                PreambleUtil.insertListCount(this.wmem, ++couponCount);
                PreambleUtil.insertEmptyFlag(this.wmem, false);
                if (couponCount >= len) {
                    if (this.lgConfigK < 8) {
                        return DirectCouponList.promoteListOrSetToHll(this);
                    }
                    return DirectCouponList.promoteListToSet(this);
                }
                return this;
            }
            if (couponAtIdx != coupon) continue;
            return this;
        }
        throw new SketchesStateException("Invalid State: no empties & no duplicates");
    }

    @Override
    int getCompactSerializationBytes() {
        return this.getMemDataStart() + (this.getCouponCount() << 2);
    }

    @Override
    int getCouponCount() {
        return PreambleUtil.extractListCount(this.mem);
    }

    @Override
    int[] getCouponIntArr() {
        return null;
    }

    @Override
    PairIterator iterator() {
        long dataStart = this.getMemDataStart();
        int lenInts = this.compact ? this.getCouponCount() : 1 << this.getLgCouponArrInts();
        return new IntMemoryPairIterator(this.mem, dataStart, lenInts, this.lgConfigK);
    }

    @Override
    int getLgCouponArrInts() {
        int lgArr = PreambleUtil.extractLgArr(this.mem);
        if (lgArr >= 3) {
            return lgArr;
        }
        int coupons = this.getCouponCount();
        return PreambleUtil.computeLgArr(this.mem, coupons, this.lgConfigK);
    }

    @Override
    int getMemDataStart() {
        return PreambleUtil.LIST_INT_ARR_START;
    }

    @Override
    Memory getMemory() {
        return this.mem;
    }

    @Override
    int getPreInts() {
        return 2;
    }

    @Override
    WritableMemory getWritableMemory() {
        return this.wmem;
    }

    @Override
    boolean isCompact() {
        return this.compact;
    }

    @Override
    boolean isMemory() {
        return true;
    }

    @Override
    boolean isOffHeap() {
        return this.mem.isDirect();
    }

    @Override
    boolean isOutOfOrderFlag() {
        return PreambleUtil.extractOooFlag(this.mem);
    }

    @Override
    boolean isSameResource(Memory mem) {
        return this.mem.isSameResource((Object)mem);
    }

    @Override
    void putOutOfOrderFlag(boolean oooFlag) {
        assert (this.wmem != null);
        PreambleUtil.insertOooFlag(this.wmem, oooFlag);
    }

    @Override
    DirectCouponList reset() {
        if (this.wmem == null) {
            throw new SketchesArgumentException("Cannot reset a read-only sketch");
        }
        int bytes = HllSketch.getMaxUpdatableSerializationBytes(this.lgConfigK, this.tgtHllType);
        this.wmem.clear(0L, (long)bytes);
        return DirectCouponList.newInstance(this.lgConfigK, this.tgtHllType, this.wmem);
    }

    static final DirectCouponHashSet promoteListToSet(DirectCouponList src) {
        WritableMemory wmem = src.wmem;
        HllUtil.checkPreamble((Memory)wmem);
        int lgConfigK = src.lgConfigK;
        TgtHllType tgtHllType = src.tgtHllType;
        int srcOffset = PreambleUtil.LIST_INT_ARR_START;
        int couponArrInts = 1 << src.getLgCouponArrInts();
        int[] couponArr = new int[couponArrInts];
        wmem.getIntArray((long)srcOffset, couponArr, 0, couponArrInts);
        PreambleUtil.insertPreInts(wmem, 3);
        PreambleUtil.insertLgArr(wmem, 5);
        PreambleUtil.insertFlags(wmem, 16);
        PreambleUtil.insertCurMin(wmem, 0);
        PreambleUtil.insertCurMode(wmem, CurMode.SET);
        int maxBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        wmem.clear((long)PreambleUtil.LIST_INT_ARR_START, (long)(maxBytes - PreambleUtil.LIST_INT_ARR_START));
        DirectCouponHashSet dchSet = new DirectCouponHashSet(src.lgConfigK, src.tgtHllType, src.wmem);
        for (int i = 0; i < couponArrInts; ++i) {
            int coupon = couponArr[i];
            if (coupon == 0) continue;
            dchSet.couponUpdate(coupon);
        }
        return dchSet;
    }

    static final DirectHllArray promoteListOrSetToHll(DirectCouponList src) {
        WritableMemory wmem = src.wmem;
        HllUtil.checkPreamble((Memory)wmem);
        int lgConfigK = src.lgConfigK;
        TgtHllType tgtHllType = src.tgtHllType;
        int srcMemDataStart = src.getMemDataStart();
        double est = src.getEstimate();
        int couponArrInts = 1 << src.getLgCouponArrInts();
        int[] couponArr = new int[couponArrInts];
        wmem.getIntArray((long)srcMemDataStart, couponArr, 0, couponArrInts);
        PreambleUtil.insertPreInts(wmem, 10);
        PreambleUtil.insertLgArr(wmem, 0);
        PreambleUtil.insertFlags(wmem, 0);
        PreambleUtil.insertCurMin(wmem, 0);
        PreambleUtil.insertCurMode(wmem, CurMode.HLL);
        int maxBytes = HllSketch.getMaxUpdatableSerializationBytes(lgConfigK, tgtHllType);
        wmem.clear((long)PreambleUtil.LIST_INT_ARR_START, (long)(maxBytes - PreambleUtil.LIST_INT_ARR_START));
        PreambleUtil.insertNumAtCurMin(wmem, 1 << lgConfigK);
        PreambleUtil.insertKxQ0(wmem, 1 << lgConfigK);
        DirectHllArray dirHllArr = tgtHllType == TgtHllType.HLL_4 ? new DirectHll4Array(lgConfigK, wmem) : (tgtHllType == TgtHllType.HLL_6 ? new DirectHll6Array(lgConfigK, wmem) : new DirectHll8Array(lgConfigK, wmem));
        for (int i = 0; i < couponArrInts; ++i) {
            int coupon = couponArr[i];
            if (coupon == 0) continue;
            dirHllArr.couponUpdate(coupon);
        }
        dirHllArr.putHipAccum(est);
        return dirHllArr;
    }
}

