/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IDataObject;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;

public class IndividualSpacings
extends MapPropertyHolder
implements IDataObject {
    private static final long serialVersionUID = 737614242607924309L;
    private static final String SERIALIZED_OPTION_SEPARATOR = ";,;";

    public IndividualSpacings() {
    }

    public IndividualSpacings(IndividualSpacings other) {
        this.getAllProperties().putAll(other.getAllProperties());
    }

    public static <T> T getIndividualOrInherited(ElkNode node, IProperty<T> property) {
        IPropertyHolder individualSpacings;
        T result = null;
        if (node.hasProperty(CoreOptions.SPACING_INDIVIDUAL) && (individualSpacings = (IPropertyHolder)node.getProperty(CoreOptions.SPACING_INDIVIDUAL)).hasProperty(property)) {
            result = individualSpacings.getProperty(property);
        }
        if (result == null && node.getParent() != null) {
            result = node.getParent().getProperty(property);
        }
        return result;
    }

    public static <T> T getIndividualOrInherited(GraphAdapters.NodeAdapter<?> node, IProperty<T> property) {
        IPropertyHolder individualSpacings;
        T result = null;
        if (node.hasProperty(CoreOptions.SPACING_INDIVIDUAL) && (individualSpacings = (IPropertyHolder)node.getProperty(CoreOptions.SPACING_INDIVIDUAL)).hasProperty(property)) {
            result = individualSpacings.getProperty(property);
        }
        if (result == null && node.getGraph() != null) {
            result = node.getGraph().getProperty(property);
        }
        if (result == null) {
            result = property.getDefault();
        }
        return result;
    }

    public String toString() {
        String serialized = this.getAllProperties().entrySet().stream().map(entry -> ((IProperty)entry.getKey()).getId() + ":" + entry.getValue().toString()).collect(Collectors.joining(SERIALIZED_OPTION_SEPARATOR));
        return serialized;
    }

    @Override
    public void parse(String string) {
        if (Strings.isNullOrEmpty(string)) {
            return;
        }
        try {
            String[] options;
            String[] stringArray = options = string.split(SERIALIZED_OPTION_SEPARATOR);
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String optionString = stringArray[n2];
                String[] option = optionString.split("\\:");
                LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionDataBySuffix(option[0]);
                if (optionData == null) {
                    throw new IllegalArgumentException("Invalid option id: " + option[0]);
                }
                Object value = optionData.parseValue(option[1]);
                if (value == null) {
                    throw new IllegalArgumentException("Invalid option value: " + option[1]);
                }
                this.setProperty((IProperty)optionData, value);
                ++n2;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The given string does not match the expected format for individual spacings.", e);
        }
    }
}

