/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.object.Shape;
import java.nio.ByteBuffer;

public class PMemoryBIO
extends PythonObject {
    private byte[] bytes = PythonUtils.EMPTY_BYTE_ARRAY;
    private int readPosition;
    private int writePosition;
    private boolean eofWritten;

    public PMemoryBIO(Object pythonClass, Shape instanceShape) {
        super(pythonClass, instanceShape);
    }

    public int getPending() {
        return this.writePosition - this.readPosition;
    }

    public int getReadPosition() {
        return this.readPosition;
    }

    public int getWritePosition() {
        return this.writePosition;
    }

    public void advanceReadPosition(int by) throws OverflowException {
        assert (by >= 0);
        this.readPosition = PythonUtils.addExact(this.readPosition, by);
        assert (this.readPosition <= this.writePosition);
    }

    public void advanceWritePosition(int by) throws OverflowException {
        assert (by >= 0);
        this.writePosition = PythonUtils.addExact(this.writePosition, by);
        assert (this.writePosition <= this.bytes.length);
    }

    public byte[] getInternalBytes() {
        return this.bytes;
    }

    public ByteBuffer getBufferForReading() {
        return ByteBuffer.wrap(this.bytes, this.readPosition, this.getPending());
    }

    public void applyRead(ByteBuffer buffer) {
        if (buffer.array() == this.bytes) {
            this.readPosition = buffer.position();
            assert (this.readPosition <= this.writePosition);
        }
    }

    public ByteBuffer getBufferForWriting() {
        return ByteBuffer.wrap(this.bytes, this.writePosition, this.bytes.length - this.writePosition);
    }

    public void applyWrite(ByteBuffer buffer) {
        if (buffer.array() == this.bytes) {
            this.writePosition = buffer.position();
            assert (this.readPosition <= this.writePosition);
            assert (this.writePosition <= this.bytes.length);
        }
    }

    public void ensureWriteCapacity(int capacity) throws OverflowException {
        if (this.bytes.length - this.writePosition < capacity) {
            int pending = this.getPending();
            if (this.bytes.length - pending < capacity) {
                byte[] newBytes = new byte[PythonUtils.addExact(capacity, pending)];
                PythonUtils.arraycopy(this.bytes, this.readPosition, newBytes, 0, pending);
                this.bytes = newBytes;
            } else {
                PythonUtils.arraycopy(this.bytes, this.readPosition, this.bytes, 0, pending);
            }
            this.readPosition = 0;
            this.writePosition = pending;
        }
    }

    public byte[] read(int length) {
        int len = Math.min(length, this.getPending());
        byte[] to = new byte[len];
        PythonUtils.arraycopy(this.bytes, this.readPosition, to, 0, len);
        this.readPosition += len;
        return to;
    }

    public void write(byte[] from, int length) throws OverflowException {
        this.ensureWriteCapacity(length);
        PythonUtils.arraycopy(from, 0, this.bytes, this.writePosition, Math.min(length, from.length));
        this.writePosition += length;
    }

    public boolean didWriteEOF() {
        return this.eofWritten;
    }

    public boolean isEOF() {
        return this.eofWritten && this.getPending() == 0;
    }

    public void writeEOF() {
        this.eofWritten = true;
    }

    public byte getByte(int offset) {
        return this.bytes[this.readPosition + offset];
    }
}

