/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.internal.controller.ControllerServerImpl;
import com.ibm.db2.cmx.internal.monitor.MonitorServerImpl;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.server.CMXServerException;
import com.ibm.db2.cmx.server.Controller;
import com.ibm.db2.cmx.server.Monitor;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerFactory {
    private static Logger logger__ = Log.getCMXServerLogger();

    public static Controller createControllerServer(int n2, boolean bl2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, ServerFactory.class, "createControllerServer", "ENTRY " + Arrays.deepToString(new Object[]{n2, bl2}));
        }
        return new ControllerServerImpl(n2, bl2);
    }

    public static Controller createControllerServer(int n2, boolean bl2, String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, ServerFactory.class, "createControllerServer", "ENTRY " + Arrays.deepToString(new Object[]{n2, bl2}));
        }
        return new ControllerServerImpl(n2, bl2, string);
    }

    public static Monitor createMonitorServer(String string, String[] stringArray, int n2, boolean bl2, int n3, int n4) throws CMXServerException {
        int n5;
        int n6 = 0;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, ServerFactory.class, "createMonitorServer", "ENTRY " + Arrays.deepToString(new Object[]{string, stringArray, n2, bl2, n3, n4}));
        }
        if (string == null) {
            throw new CMXServerException(2);
        }
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            if (stringArray[n5] == null) continue;
            ++n6;
        }
        if (stringArray == null || n6 <= 0) {
            throw new CMXServerException(1);
        }
        String[] stringArray2 = new String[n6];
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            if (stringArray[n5] == null) continue;
            stringArray2[n5] = Configuration.resolveToIPAddress(stringArray[n5]);
        }
        MonitorServerImpl monitorServerImpl = new MonitorServerImpl(string, null, stringArray2, n2, bl2, n3, n4);
        return monitorServerImpl;
    }

    public static Monitor createMonitorServer(String string, int n2, boolean bl2, int n3, int n4) throws CMXServerException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, ServerFactory.class, "createMonitorServer", "ENTRY " + Arrays.deepToString(new Object[]{string, n2, bl2, n3, n4}));
        }
        if (string == null) {
            throw new CMXServerException(2);
        }
        MonitorServerImpl monitorServerImpl = new MonitorServerImpl(string, null, null, n2, bl2, n3, n4);
        return monitorServerImpl;
    }

    public static Monitor createMonitorServer(String string, String string2, int n2, boolean bl2, int n3, int n4) throws CMXServerException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, ServerFactory.class, "createMonitorServer", "ENTRY " + Arrays.deepToString(new Object[]{string, string2, n2, bl2, n3, n4}));
        }
        if (string == null || string2 == null) {
            throw new CMXServerException(2);
        }
        MonitorServerImpl monitorServerImpl = new MonitorServerImpl(string, string2, null, n2, bl2, n3, n4);
        return monitorServerImpl;
    }

    public static Monitor createMonitorServer(int n2, boolean bl2, int n3, int n4) throws CMXServerException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, ServerFactory.class, "createMonitorServer", "ENTRY " + Arrays.deepToString(new Object[]{n2, bl2, n3, n4}));
        }
        MonitorServerImpl monitorServerImpl = new MonitorServerImpl(null, null, null, n2, bl2, n3, n4);
        return monitorServerImpl;
    }
}

