/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.solr.analytics.facet.compare.ExpressionComparator;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.common.SolrException;

public class StringField
extends AnalyticsField
implements StringValue.CastingStringValue {
    private BinaryDocValues binaryDocValues;
    private SortedDocValues sortedDocValues;
    String value;
    boolean exists = false;

    public StringField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        FieldInfo fieldInfo = context.reader().getFieldInfos().fieldInfo(this.fieldName);
        if (fieldInfo == null) {
            this.binaryDocValues = DocValues.emptyBinary();
            this.sortedDocValues = null;
        } else {
            switch (fieldInfo.getDocValuesType()) {
                case BINARY: {
                    this.binaryDocValues = DocValues.getBinary((LeafReader)context.reader(), (String)this.fieldName);
                    this.sortedDocValues = null;
                    break;
                }
                case SORTED: {
                    this.binaryDocValues = null;
                    this.sortedDocValues = DocValues.getSorted((LeafReader)context.reader(), (String)this.fieldName);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid doc values type " + String.valueOf(fieldInfo.getDocValuesType()));
                }
            }
        }
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.binaryDocValues == null) {
            this.exists = this.sortedDocValues.advanceExact(doc);
            if (this.exists) {
                this.value = this.sortedDocValues.lookupOrd(this.sortedDocValues.ordValue()).utf8ToString();
            }
        } else {
            this.exists = this.binaryDocValues.advanceExact(doc);
            if (this.exists) {
                this.value = this.binaryDocValues.binaryValue().utf8ToString();
            }
        }
    }

    @Override
    public String getString() {
        return this.exists ? this.value : null;
    }

    @Override
    public Object getObject() {
        return this.exists ? this.value : null;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        if (this.exists) {
            cons.accept(this.value);
        }
    }

    @Override
    public ExpressionComparator<String> getObjectComparator(String expression) {
        return new ExpressionComparator<String>(expression);
    }
}

