/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.InvalidValueException;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.CalcColEvalContext;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.MemoColumnImpl;
import com.healthmarketscience.jackcess.impl.NumericColumnImpl;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.TextColumnImpl;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class CalculatedColumnUtil {
    private static final int CALC_DATA_LEN_OFFSET = 16;
    private static final int CALC_DATA_OFFSET = 20;
    static final int CALC_EXTRA_DATA_LEN = 23;
    static final short CALC_FIXED_FIELD_LEN = 39;
    private static final byte[] CALC_BOOL_TRUE = CalculatedColumnUtil.wrapCalculatedValue(new byte[]{-1});
    private static final byte[] CALC_BOOL_FALSE = CalculatedColumnUtil.wrapCalculatedValue(new byte[]{0});

    CalculatedColumnUtil() {
    }

    static ColumnImpl create(ColumnImpl.InitArgs args) throws IOException {
        switch (args.type) {
            case BOOLEAN: {
                return new CalcBooleanColImpl(args);
            }
            case TEXT: {
                return new CalcTextColImpl(args);
            }
            case MEMO: {
                return new CalcMemoColImpl(args);
            }
        }
        if (args.type.getHasScalePrecision()) {
            return new CalcNumericColImpl(args);
        }
        return new CalcColImpl(args);
    }

    private static byte[] unwrapCalculatedValue(byte[] data) {
        if (data.length < 20) {
            return data;
        }
        ByteBuffer buffer = PageChannel.wrap(data);
        buffer.position(16);
        int dataLen = buffer.getInt();
        byte[] newData = new byte[Math.min(buffer.remaining(), dataLen)];
        buffer.get(newData);
        return newData;
    }

    private static ByteBuffer wrapCalculatedValue(ByteBuffer buffer) {
        ByteBuffer newBuf = CalculatedColumnUtil.prepareWrappedCalcValue(buffer.remaining(), buffer.order());
        newBuf.put(buffer);
        newBuf.rewind();
        return newBuf;
    }

    private static byte[] wrapCalculatedValue(byte[] data) {
        int dataLen = data.length;
        data = ByteUtil.copyOf(data, 0, dataLen + 23, 20);
        PageChannel.wrap(data).putInt(16, dataLen);
        return data;
    }

    private static ByteBuffer prepareWrappedCalcValue(int dataLen, ByteOrder order) {
        ByteBuffer buffer = ByteBuffer.allocate(dataLen + 23).order(order);
        buffer.putInt(16, dataLen);
        buffer.position(20);
        return buffer;
    }

    private static class CalcNumericColImpl
    extends NumericColumnImpl {
        private CalcColEvalContext _calcCol;

        CalcNumericColImpl(ColumnImpl.InitArgs args) throws IOException {
            super(args);
        }

        @Override
        protected CalcColEvalContext getCalculationContext() {
            return this._calcCol;
        }

        @Override
        protected void setCalcColEvalContext(CalcColEvalContext calcCol) {
            this._calcCol = calcCol;
        }

        @Override
        public byte getPrecision() {
            return (byte)this.getType().getMaxPrecision();
        }

        @Override
        public Object read(byte[] data, ByteOrder order) throws IOException {
            if ((data = CalculatedColumnUtil.unwrapCalculatedValue(data)).length == 0) {
                return null;
            }
            return CalcNumericColImpl.readCalcNumericValue(ByteBuffer.wrap(data).order(order));
        }

        @Override
        protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
            int totalDataLen = Math.min(43, this.getLength());
            int dataLen = CalcNumericColImpl.toMul4(totalDataLen - 23);
            ByteBuffer buffer = CalculatedColumnUtil.prepareWrappedCalcValue(dataLen, order);
            this.writeCalcNumericValue(buffer, obj, dataLen);
            buffer.rewind();
            return buffer;
        }

        private static BigDecimal readCalcNumericValue(ByteBuffer buffer) {
            int totalLen = buffer.getShort();
            int numByteLen = (totalLen > 0 ? totalLen : buffer.remaining()) - 2;
            numByteLen = Math.min(CalcNumericColImpl.toMul4(numByteLen), 16);
            byte scale = buffer.get();
            boolean negate = buffer.get() != 0;
            byte[] tmpArr = ByteUtil.getBytes(buffer, numByteLen);
            if (buffer.order() != ByteOrder.BIG_ENDIAN) {
                CalcNumericColImpl.fixNumericByteOrder(tmpArr);
            }
            return CalcNumericColImpl.toBigDecimal(tmpArr, negate, scale);
        }

        private void writeCalcNumericValue(ByteBuffer buffer, Object value, int dataLen) throws IOException {
            Object inValue = value;
            try {
                BigDecimal decVal = this.toBigDecimal(value);
                inValue = decVal;
                int signum = decVal.signum();
                if (signum < 0) {
                    decVal = decVal.negate();
                }
                int maxScale = this.getType().getMaxScale();
                if (decVal.scale() > maxScale) {
                    decVal = decVal.setScale(maxScale);
                }
                int scale = decVal.scale();
                if (decVal.precision() > this.getType().getMaxPrecision()) {
                    throw new InvalidValueException(this.withErrorContext("Numeric value is too big for specified precision " + this.getType().getMaxPrecision() + ": " + decVal));
                }
                byte[] intValBytes = this.toUnscaledByteArray(decVal, dataLen - 4);
                if (buffer.order() != ByteOrder.BIG_ENDIAN) {
                    CalcNumericColImpl.fixNumericByteOrder(intValBytes);
                }
                buffer.putShort((short)(dataLen - 2));
                buffer.put((byte)scale);
                buffer.put(signum < 0 ? (byte)-128 : 0);
                buffer.put(intValBytes);
            }
            catch (ArithmeticException e) {
                throw new IOException(this.withErrorContext("Numeric value '" + inValue + "' out of range"), e);
            }
        }

        private static void fixNumericByteOrder(byte[] bytes) {
            int pos = 0;
            if (bytes.length % 8 != 0) {
                ByteUtil.swap4Bytes(bytes, 0);
                pos += 4;
            }
            while (pos < bytes.length) {
                ByteUtil.swap8Bytes(bytes, pos);
                pos += 8;
            }
        }

        private static int toMul4(int val) {
            return val / 4 * 4;
        }
    }

    private static class CalcMemoColImpl
    extends MemoColumnImpl {
        private CalcColEvalContext _calcCol;

        CalcMemoColImpl(ColumnImpl.InitArgs args) throws IOException {
            super(args);
        }

        @Override
        protected CalcColEvalContext getCalculationContext() {
            return this._calcCol;
        }

        @Override
        protected void setCalcColEvalContext(CalcColEvalContext calcCol) {
            this._calcCol = calcCol;
        }

        @Override
        protected int calcMaxLengthInUnits() {
            return this.getType().toUnitSize(this.getType().getMaxSize() - 23, this.getFormat());
        }

        @Override
        protected byte[] readLongValue(byte[] lvalDefinition) throws IOException {
            return CalculatedColumnUtil.unwrapCalculatedValue(super.readLongValue(lvalDefinition));
        }

        @Override
        protected ByteBuffer writeLongValue(byte[] value, int remainingRowLength) throws IOException {
            return super.writeLongValue(CalculatedColumnUtil.wrapCalculatedValue(value), remainingRowLength);
        }
    }

    private static class CalcTextColImpl
    extends TextColumnImpl {
        private CalcColEvalContext _calcCol;

        CalcTextColImpl(ColumnImpl.InitArgs args) throws IOException {
            super(args);
        }

        @Override
        protected CalcColEvalContext getCalculationContext() {
            return this._calcCol;
        }

        @Override
        protected void setCalcColEvalContext(CalcColEvalContext calcCol) {
            this._calcCol = calcCol;
        }

        @Override
        protected int calcLengthInUnits() {
            return this.getType().toUnitSize(this.getLength() - 23, this.getFormat());
        }

        @Override
        public Object read(byte[] data, ByteOrder order) throws IOException {
            return this.decodeTextValue(CalculatedColumnUtil.unwrapCalculatedValue(data));
        }

        @Override
        protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
            return CalculatedColumnUtil.wrapCalculatedValue(super.writeRealData(obj, remainingRowLength, order));
        }
    }

    private static class CalcBooleanColImpl
    extends ColumnImpl {
        private CalcColEvalContext _calcCol;

        CalcBooleanColImpl(ColumnImpl.InitArgs args) throws IOException {
            super(args);
        }

        @Override
        protected CalcColEvalContext getCalculationContext() {
            return this._calcCol;
        }

        @Override
        protected void setCalcColEvalContext(CalcColEvalContext calcCol) {
            this._calcCol = calcCol;
        }

        @Override
        public boolean storeInNullMask() {
            return false;
        }

        @Override
        public Object read(byte[] data, ByteOrder order) throws IOException {
            if ((data = CalculatedColumnUtil.unwrapCalculatedValue(data)).length == 0) {
                return Boolean.FALSE;
            }
            return data[0] != 0 ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
            return ByteBuffer.wrap(CalcBooleanColImpl.toBooleanValue(obj) ? CALC_BOOL_TRUE : CALC_BOOL_FALSE).order(order);
        }
    }

    private static class CalcColImpl
    extends ColumnImpl {
        private CalcColEvalContext _calcCol;

        CalcColImpl(ColumnImpl.InitArgs args) throws IOException {
            super(args);
        }

        @Override
        protected CalcColEvalContext getCalculationContext() {
            return this._calcCol;
        }

        @Override
        protected void setCalcColEvalContext(CalcColEvalContext calcCol) {
            this._calcCol = calcCol;
        }

        @Override
        public Object read(byte[] data, ByteOrder order) throws IOException {
            if ((data = CalculatedColumnUtil.unwrapCalculatedValue(data)).length == 0 && !this.getType().isVariableLength()) {
                return null;
            }
            return super.read(data, order);
        }

        @Override
        protected ByteBuffer writeRealData(Object obj, int remainingRowLength, ByteOrder order) throws IOException {
            ByteBuffer buffer = this.writeFixedLengthField(obj, CalculatedColumnUtil.prepareWrappedCalcValue(this.getType().getFixedSize(), order));
            buffer.rewind();
            return buffer;
        }
    }
}

