/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;

public class ExpressionValueSourceParser
extends ValueSourceParser {
    public static final String SCORE_KEY = "score-name";
    public static final String EXPRESSION_KEY = "expression";
    private Expression expression;
    private String scoreKey;
    private int numPositionalArgs = 0;

    @Override
    public void init(NamedList<?> args) {
        this.initConfiguredExpression(args);
        this.initScoreKey(args);
        super.init(args);
    }

    private void initScoreKey(NamedList<?> args) {
        this.scoreKey = Optional.ofNullable((String)args.remove(SCORE_KEY)).orElse("score");
    }

    private void initConfiguredExpression(NamedList<?> args) {
        String expressionStr = Optional.ofNullable((String)args.remove(EXPRESSION_KEY)).orElseThrow(() -> new SolrException(SolrException.ErrorCode.SERVER_ERROR, "expression must be configured with an expression"));
        Pattern pattern = Pattern.compile("\\$(\\d+)");
        Matcher matcher = pattern.matcher(expressionStr);
        while (matcher.find()) {
            int argNum = Integer.parseInt(matcher.group(1));
            this.numPositionalArgs = Math.max(this.numPositionalArgs, argNum);
        }
        try {
            this.expression = JavascriptCompiler.compile((String)expressionStr);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to parse javascript expression: " + expressionStr, (Throwable)e);
        }
    }

    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        assert (null != fp);
        ArrayList<DoubleValuesSource> positionalArgs = new ArrayList<DoubleValuesSource>();
        for (int i = 0; i < this.numPositionalArgs; ++i) {
            ValueSource vs = fp.parseValueSource();
            positionalArgs.add(vs.asDoubleValuesSource());
        }
        IndexSchema schema = fp.getReq().getSchema();
        SolrBindings b = new SolrBindings(this.scoreKey, schema, positionalArgs);
        return ValueSource.fromDoubleValuesSource((DoubleValuesSource)this.expression.getDoubleValuesSource((Bindings)b));
    }

    public static class SolrBindings
    extends Bindings {
        private final String scoreKey;
        private final IndexSchema schema;
        private final List<DoubleValuesSource> positionalArgs;

        public SolrBindings(String scoreKey, IndexSchema schema, List<DoubleValuesSource> positionalArgs) {
            this.scoreKey = scoreKey;
            this.schema = schema;
            this.positionalArgs = positionalArgs != null ? positionalArgs : new ArrayList();
        }

        public DoubleValuesSource getDoubleValuesSource(String key) {
            assert (null != key);
            if (Objects.equals(this.scoreKey, key)) {
                return DoubleValuesSource.SCORES;
            }
            if (key.startsWith("$")) {
                try {
                    int position = Integer.parseInt(key.substring(1));
                    return this.positionalArgs.get(position - 1);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException("Not a valid positional argument: " + key, e);
                }
            }
            SchemaField field = this.schema.getFieldOrNull(key);
            if (null != field) {
                return field.getType().getValueSource(field, null).asDoubleValuesSource();
            }
            throw new IllegalArgumentException("No binding or schema field for key: " + key);
        }
    }
}

